' Program INT_ENC.INC
' Rotary Encoder Reader Include file
' Using a TMR0 interrupt and the ON_INTERRUPT command

' To check the Rotary encoder read the variable DIRECTION 
' This will hold the specific direction of the encoder
' A result of 128 (Bit-7) means encoder turning left
' A result of 1 (Bit-0) means encoder turning right
' A result of 0 means the encoder is stationary


' Three new defines establish which Port and pins the Rotary encoder is attached to
' as well as enabling the portB pullups resistors
' These are: -

'	Define	ENC_PORT
'	Define  ENC_BIT		
'	Define  ENC_PULLUPS

' ENC_PORT defines which PORT the encoder is attached to.

' ENC_BIT defines which BIT Channel-A of the encoder is attached to
' Channel-B of the encoder must be attached to the next bit up
' For instance if the define ENC_BIT is given the value 0 then
' Channel-A will be attached to PortB.0, and Channel-B will be attached to PortB.1

' ENC_PULLUPS will enable the internal PortB pullups is set to 1,
' and disable the resistors if 0

' ** Pre-declare the variables used in the subroutine **

	Enc_Temp	Var	Byte		' Temporary variable for Encoder subroutine
	Direction   	Var 	Byte	SYSTEM	' Direction bit FLAGs If Bit-0=1 then turning right
						'		      If Bit-7=1 then turning left
	Enc_Old 	Var 	Byte		' Original value of Encoder State
	Enc_New 	Var 	Byte		' New value of Encoder State
	Enc_Mask	Var	Byte		' Value to MASK the Encoder Pins
	Deb		Var	Byte		' Debounce Loop

' ** Declare the bits and flags of the various registers **

	T0IE		Var	INTCON.5	' Timer0 Overflow Interrupt Enable
	T0IF		Var	INTCON.2	' Timer0 Overflow Interrupt Flag
	GIE		Var	INTCON.7	' Global Interrupt Enable
	PS0		Var	OPTION_REG.0	' Prescaler division bit-0
	PS1		Var	OPTION_REG.1	' Prescaler division bit-1
	PS2		Var	OPTION_REG.2	' Prescaler division bit-2
	PSA		Var	OPTION_REG.3	' Prescaler Assignment (1= assigned to WDT)
						'		       (0= assigned to oscillator)
	T0CS		Var	OPTION_REG.5	' Timer0 Clock Source Select (0=Internal clock) 
						'			     (1=External PORTA.4)

	Goto Over_Encoder			' Jump Over the Encoder Subroutine

' Read the status of the Rotary encoder
' The variable DIRECTION has 2 bits set for the specific direction
' DIRECTION.7=1 when the Rotary encoder is turning LEFT
' DIRECTION.0=1 when the Rotary encoder is turning RIGHT
        Disable         		' Disable all interupts during the interrupt handler
Enc_Int:
ASM 
	Clrf Direction			; Clear the return variable before The subroutine
	Mov _Enc_New,PortB 		; Get latest state of input bits.
	And _Enc_New,_Enc_Mask		; Strip off all but the encoder bits.
	Mov _Enc_Temp,_Enc_New		; Save the value of ENC_NEW
	Xor _Enc_Temp, _Enc_Old 	; Does Enc_New = Enc_Old?
	Jz N_Exit 			; If so, Exit Without Change
	Clc 				; Clear carry in preparation for rotate-left instruction.
	Rlf _Enc_Old 			; Move ENC_OLD to the left to align ENC_OLD with ENC_NEW.
	Xor _Enc_Old,_Enc_New		; Xor ENC_NEW with ENC_OLD
	Btfsc _Enc_Old,ENC_BIT+1	; If the XOR result is 1
	Goto Left			; then jump to Direction for left turn. Else
Right 	Bsf Direction,0			; Set Direction bit-0 for right turn
	Goto Exit			; Exit Subroutine
Left 	Bsf Direction,7			; Set Direction bit-7 for left turn

Exit	Movf _Enc_New,w
	Movwf _Enc_Old			; ENC_OLD now equals ENC_NEW
N_Exit
Endasm
	T0IF=0    			' Reset TMR0 interrupt flag
        Resume				' Exit the interrupt
	Enable				' Allow more interrupts
Over_Encoder:
 
' ** Initialise the Port and bits, ready for the Encoder reader subroutine **
Asm
; Set the default PORT and BITS to PortB, bits 0-1 and Internal Pullup resistors ON
	ifndef ENC_PORT
ENC_PORT=PORTB
	endif
	ifndef ENC_BIT
ENC_BIT=0
	endif
	ifndef ENC_PULLUPS
ENC_PULLUPS=1
	endif

; ** Determine if PortB is being used **
; ** If it is and ENC_PULLUPS is set then Enable PortB Pullups **
	if (ENC_PULLUPS == 1)
	if (ENC_PORT == PortB)
	Bsf Status,5				; Point to Page1
	Bcf OPTION_REG,7			; Enable the pullup resistors
	Bcf Status,5				; Back to Page0
	endif
	endif

; ** Assign the Specified Port and Bits as Inputs **

	Bcf ENC_PORT,ENC_BIT			;' Clear the appropriate pin for channel-A
	Bcf ENC_PORT,ENC_BIT+1			;' Clear the appropriate pin for channel-B
	Bsf Status,5				;' Point to Page1
	Bsf ENC_PORT,ENC_BIT			;' Make the channel-A pin an input
	Bsf ENC_PORT,ENC_BIT+1			;' Make the channel-B pin an input
	Bcf Status,5				;' Back to Page0

;' Adjust the MASK value according to the ENC_BIT define
	Clrf _Enc_Mask				; Clear the Enc_Mask variable
	if (ENC_BIT == 0)
	Movlw 00000011b
	endif

	if (ENC_BIT == 1)
	Movlw 00000110b
	endif

	If (ENC_BIT == 2)
	Movlw 00001100b
	endif

	If (ENC_BIT == 3)
	Movlw 00011000b
	endif

	If (ENC_BIT == 4)
	Movlw 00110000b
	endif

	If (ENC_BIT == 5)
	Movlw 01100000b
	endif

	If (ENC_BIT == 6)
	Movlw 11000000b
	endif

	Iorwf _Enc_Mask				; Superimpose the bits into ENC_MASK
	Movf ENC_PORT,w				; Read the Value of the appropriate Port
	Movwf _Enc_Old				; And store it in ENC_OLD
	Movf _Enc_Mask,w			; Get the ENC_MASK Value
	Andwf _Enc_Old,f			; AND it with _ENC_OLD to Enc_Mask the correct bits
Endasm

' Set TMR0 to interrupt
	GIE=0					' Turn off global interrupts
	While GIE=1:GIE=0:Wend			' Make sure they are off
	PSA=0					' Assign the prescaler to external oscillator
	PS0=0					' Set the prescaler
	PS1=0					' to increment TMR0
	PS2=0					' every 2nd instruction cycle
	T0CS=0					' Assign TMR0 clock to internal source
	TMR0=0					' Clear TMR0 initially
	T0IE=1					' Enable TMR0 overflow interrupt
	GIE=1					' Enable global interrupts

        On Interrupt Goto Enc_Int		' Point to the interrupt handler


